# -*- coding: utf-8 -*-
"""
Created on Wed Apr 28 09:51:34 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

CM_SUBSECTION_BLUES = np.linspace(0.3, 1.0, 1000) 
COLOURS_BLUES = [ cm.Blues(x) for x in CM_SUBSECTION_BLUES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
#main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = main_folder_path
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

# =============================================================================
# df_Al2O3 = pd.read_csv(os.path.join(main_folder_path, 'ellipsometry al2o3 on Si.csv'))
# df_TFB = pd.read_csv(os.path.join(main_folder_path, 'dektak avg ellipsometry al2o3 on tfb.csv'))
# =============================================================================
df_Al2O3 = pd.read_csv(os.path.join(main_folder_path, 'ellipsometry al2o3 on Si cauchy600nm.csv'))
df_TFB = pd.read_csv(os.path.join(main_folder_path, 'dektak avg ellipsometry cauchy al2o3 on tfb.csv'))




"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Prepare plots"""                                              
fig = plt.figure(figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])
ax.set_xlabel('ALD cycles')
ax.set_ylabel('Increase rel. bare TFB [nm]')

"""Plot the data"""
pae, = ax.plot(df_Al2O3['ALD cycles'][1:], df_Al2O3['Al2O3 on Si'][1:]-df_Al2O3['Al2O3 on Si'][0], linestyle='dotted', marker='s', markersize=3.5*lw, color='grey')
pt5d, = ax.plot(df_TFB['ALD cycles'][1:], df_TFB['TFB 5 mg/ml Dektak average'][1:]-df_TFB['TFB 5 mg/ml Dektak average'][0], marker='o', markersize=3.5*lw, color=COLOURS_GREENS[800])
pt5e, = ax.plot(df_TFB['ALD cycles'][1:], df_TFB['TFB 5 mg/ml ellipsometry'][1:]-df_TFB['TFB 5 mg/ml ellipsometry'][0], linestyle='dotted', marker='s', markersize=3.5*lw, color=COLOURS_GREENS[350])
pt10d, = ax.plot(df_TFB['ALD cycles'][1:], df_TFB['TFB 10 mg/ml Dektak average'][1:]-df_TFB['TFB 10 mg/ml Dektak average'][0], marker='o', markersize=3.5*lw, color=COLOURS_BLUES[600])
pt10e, = ax.plot(df_TFB['ALD cycles'][1:], df_TFB['TFB 10 mg/ml ellipsometry'][1:]-df_TFB['TFB 10 mg/ml ellipsometry'][0], linestyle='dotted', marker='s', markersize=3.5*lw, color=COLOURS_BLUES[250])

"""Axis settings"""
ax.set_ylim(bottom=0, top=29.5)
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(4))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(2))

"""Legend"""
ellip_labels = ['TFB 11 nm', 'TFB 26 nm', '$\mathrm{Al_2O_3}$ on Si', ]
dektak_labels = ['TFB 11 nm', 'TFB 26 nm']

leg = ax.legend([pt5e, pt10e, pae, pt5d, pt10d],
              ellip_labels + dektak_labels,
              title='Ellipsometry            Profilometry',
              ncol=2, frameon = False,
              loc='upper left', bbox_to_anchor=(-0.03, 1.03))

ax.add_artist(leg)

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
export_name = 'Plot'
plot_name = ' relative thickness increase'
export_name_pdf = export_name + plot_name + '.pdf'
export_name_svg = export_name + plot_name + '.svg'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path)
fig.savefig(svg_path)
plt.close(fig)

